# GDLnucleus Light – Free Version

A streamlined working environment for bidirectional conversion between ArchiCAD GSM files and HSF source files (Human Source Format).

## 🎯 What does GDLnucleus Light do?

**GDLnucleus Light** allows you to edit ArchiCAD GDL library elements in a text-based format (HSF):

- **GSM → HSF**: Converts GSM files into editable source files (scripts, XML, images)
- **HSF → GSM**: Rebuilds a GSM file from the source files

### Advantages of the HSF format:

- ✅ **Version control**: Manage GDL scripts with Git  
- ✅ **Better editing**: Edit scripts with modern code editors  
- ✅ **Team collaboration**: Track and merge changes  
- ✅ **Backup**: Automatic, timestamped backups with every conversion  

---

## 📁 Project Structure

your-project.project/
├── 01_gsms/                    # GSM library files
│   └── library-name/           # Name of your library
│       └── object-name.gsm     # Your GDL objects
│
├── 02_hsf/                     # HSF source files
│   └── object-name/
│       └── object-name/
│           ├── scripts/        # GDL scripts (1d.gdl, 2d.gdl, etc.)
│           ├── images/         # Embedded images
│           ├── paramlist.xml   # Parameter list
│           └── …
│
├── 03_backups/                 # Backups & working directory
│   ├── object-name/            # Temporary during GSM2HSF
│   └── timestamped/            # Timestamped backups
│
├── 04_logs/                    # Log files
├── .vscode/                    # VS Code configuration
│   ├── tasks.json              # Build tasks
│   ├── settings.json           # Project settings
│   └── launch.json             # Debug configuration
│
├── bin/
│   └── gdlconverter.py         # Conversion script
│
├── gdlconfig.json              # Configuration file
└── project.code-workspace      # VS Code workspace

---

## 🚀 Quick Start

### 1. Requirements

- **ArchiCAD** with LP_XMLConverter installed  
- **Python 3**
  - **macOS:** Usually preinstalled  
  - **Windows:** Install from https://www.python.org/downloads/  
    - Enable “Add Python to PATH” during installation  
- **Visual Studio Code** or **Cursor** (recommended)  
- **GDL Task Runner Extension** (recommended)

#### macOS Python Setup

On macOS, the command is usually `python3`, while the tasks use `python`.  
Create a symlink once:

```bash
sudo ln -s /usr/bin/python3 /usr/local/bin/python

Alternative: Change python to python3 in .vscode/tasks.json.

Recommended:
The script bin/gdlconverter.py contains a shebang (#!/usr/bin/env python3) and is executable.
VS Code tasks execute the script directly and set PYTHONUNBUFFERED=1, equivalent to the -u flag.

Check permissions:

ls -l bin/gdlconverter.py
chmod +x bin/gdlconverter.py


⸻

🛠 Project Setup

a) Create Folder Structure

mkdir -p 01_gsms/your-library
mkdir -p 02_hsf
mkdir -p 03_backups/timestamped
mkdir -p 04_logs

b) Place GSM Files

Copy your GSM files into:

01_gsms/your-library/object1.gsm
01_gsms/your-library/object2.gsm

Important:
The folder name under 01_gsms/ is automatically detected as the library name.

⸻

🪟 Windows-Specific Notes

Python Installation (Windows)
  1.	Download from https://www.python.org/downloads/
  2.	Enable “Add Python to PATH”
  3.	Verify in PowerShell:

python --version

Should show: Python 3.x.x

LP_XMLConverter Path (Windows)

Typical paths:

C:\Program Files\Graphisoft\ArchiCAD 27\LP_XMLConverter.exe
C:\Program Files\Graphisoft\ArchiCAD 26\LP_XMLConverter.exe
C:\Program Files\Graphisoft\ArchiCAD 28\LP_XMLConverter.exe

Example configuration in gdlconfig.json:

"platforms": {
  "windows": {
    "lpxmlconverter": "C:\\Program Files\\Graphisoft\\ArchiCAD 27\\LP_XMLConverter.exe"
  }
}


⸻

🔄 Workflow

GSM → HSF
  1.	Open the .code-workspace file in VS Code / Cursor
  2.	Run task:
  •	Via GDL Task Runner: GSM2HSF (all files)
  •	Or: Tasks → Run Task → GSM2HSF (all files)

Result:
  •	HSF files created in 02_hsf/object-name/object-name/
  •	GDL scripts located in scripts/

⸻

HSF → GSM
  1.	Edit .gdl files in 02_hsf/.../scripts/
  2.	Run task:
  •	HSF2GSM (all files)

Result:
  •	GSM file overwritten in 01_gsms/library-name/object-name.gsm
  •	Automatic backup created in 03_backups/timestamped/

⸻

Embedding Images in GDL Objects

GDLnucleus Light automatically handles image registration during HSF → GSM conversion.

  1.	Place your image file(s) in 02_hsf/object-name/object-name/images/
      (any name, e.g. my-button.png – except Picture_0.png which is reserved for the object icon)
  2.	Run HSF2GSM – the converter automatically renames the file(s) to GDLPict_1.png,
      GDLPict_2.png, … and registers them in libpartdata.xml
  3.	Reference the image in your GDL script using UI_PICT 1 (or PICTURE 1, etc.)
  4.	The image is embedded in the resulting GSM file

Note: Picture_0.png is always the object icon and is never renamed or re-registered.

⸻

📋 Available Tasks

Task	Description
GSM2HSF (all files)	Convert all GSM → HSF
HSF2GSM (all files)	Convert all HSF → GSM

Tasks execute bin/gdlconverter.py directly and use unbuffered output.

⸻

⚙️ Customization

Change Project Name

mv gdl-nucleus-light.project your-project.project
mv gdl-nucleus-light.code-workspace your-project.code-workspace

Update the workspace JSON accordingly.

Change Library Name

The first folder under 01_gsms/ defines the library name.

Important:
Avoid spaces in folder names.

Change ArchiCAD Version

Update the lpxmlconverter path in gdlconfig.json.

⸻

🔍 Troubleshooting

python3: command not found (Windows)

Install Python and enable PATH.

lpxmlconverter path not found

Correct the path in gdlconfig.json.

HSF folder not found

Run GSM2HSF first.

No library folder found

Create a folder under 01_gsms/.

Script finds no GSM files

Ensure GSM files are inside:

01_gsms/library-name/


⸻

📝 Backup Strategy

Every HSF → GSM conversion creates a backup:

03_backups/timestamped/
object_YYYY_MM_DD_HH_MM.gsm


⸻

🆚 GDLnucleus Light vs Full Version

Feature	Light	Full
GSM ↔ HSF	✅	✅
GSM ↔ XML	❌	✅
LCF container	❌	✅
Parameter CSV export	❌	✅
Image management	✅	✅
SVG → TIFF	❌	✅


⸻

💡 Best Practices
  1.	Add 02_hsf/ to Git
  2.	Ignore 03_backups/ and 04_logs/
  3.	Convert GSM → HSF once at project start
  4.	Edit only HSF afterwards
  5.	Convert back after changes
  6.	Merge conflicts in GDL scripts are readable and solvable

⸻

📄 License

Free Light version for personal and commercial use.

Version: GDLnucleus Light 1.1
Last update: February 2026

