# GDLnucleus Light - Kostenlose Version

Eine schlanke Arbeitsumgebung für die bidirektionale Konvertierung zwischen ArchiCAD GSM-Dateien und HSF-Quelldateien (Human-Source-Format).

## 🎯 Was macht GDLnucleus Light?

**GDLnucleus Light** ermöglicht es, ArchiCAD GDL-Bibliothekselemente in einem textbasierten Format (HSF) zu bearbeiten:

- **GSM → HSF**: Konvertiert GSM-Dateien in bearbeitbare Quelldateien (Scripts, XML, Bilder)
- **HSF → GSM**: Baut aus den Quelldateien wieder eine GSM-Datei

### Vorteile des HSF-Formats:
- ✅ **Versionskontrolle**: GDL-Scripts in Git verwalten
- ✅ **Bessere Bearbeitung**: Scripts mit modernen Code-Editoren bearbeiten
- ✅ **Teamarbeit**: Änderungen nachvollziehen und zusammenführen
- ✅ **Backup**: Automatische, zeitgestempelte Backups bei jeder Konvertierung

---

## 📁 Projektstruktur

```
ihr-projekt.project/
├── 01_gsms/                    # GSM-Bibliotheksdateien
│   └── bibliotheksname/        # Name Ihrer Bibliothek
│       └── objektname.gsm      # Ihre GDL-Objekte
│
├── 02_hsf/                     # HSF-Quelldateien
│   └── objektname/
│       └── objektname/
│           ├── scripts/        # GDL-Scripts (1d.gdl, 2d.gdl, etc.)
│           ├── images/         # Eingebettete Bilder
│           ├── paramlist.xml   # Parameterliste
│           └── ...
│
├── 03_backups/                 # Backups & Arbeitsverzeichnis
│   ├── objektname/             # Temporär während GSM2HSF
│   └── timestamped/            # Zeitgestempelte Backups
│
├── 04_logs/                    # Log-Dateien
├── .vscode/                    # VS Code Konfiguration
│   ├── tasks.json              # Build-Tasks
│   ├── settings.json           # Projekt-Einstellungen
│   └── launch.json             # Debug-Konfiguration
│
├── bin/
│   └── gdlconverter.py         # Konvertierungs-Script
│
├── gdlconfig.json              # Konfigurationsdatei
└── projekt.code-workspace      # VS Code Workspace
```

---

## 🚀 Schnellstart

### 1. Voraussetzungen

- **ArchiCAD** mit dem LP_XMLConverter installiert
- **Python 3**
  - **macOS:** Bereits vorinstalliert (siehe Setup-Hinweis unten!)
  - **Windows:** [Python von python.org](https://www.python.org/downloads/) installieren
    - Bei Installation: "Add Python to PATH" aktivieren!
- **Visual Studio Code** oder **Cursor** (empfohlen)
- **GDL Task Runner Extension** für VS Code/Cursor (empfohlen für einfache Task-Verwaltung)

#### macOS Python-Setup

Auf macOS heißt der Befehl normalerweise `python3`, aber die Tasks verwenden `python`. 
Erstellen Sie einen Symlink (einmalig):

```bash
# Terminal öffnen und ausführen:
sudo ln -s /usr/bin/python3 /usr/local/bin/python

# Passwort eingeben und fertig!
```

**Alternative:** Sie können auch die Tasks manuell in `.vscode/tasks.json` von `python` auf `python3` ändern.

**Hinweis (empfohlen):** Das Script `bin/gdlconverter.py` enthält nun einen Shebang (`#!/usr/bin/env python3`) und ist ausführbar. Die VS Code Tasks sind so konfiguriert, dass sie das Skript direkt ausführen (`${workspaceRoot}/bin/gdlconverter.py`) und `PYTHONUNBUFFERED=1` setzen — das entspricht dem bisherigen `-u`-Flag. Prüfen Sie die Dateiberechtigungen mit `ls -l bin/gdlconverter.py` und machen Sie die Datei ggf. ausführbar mit `chmod +x bin/gdlconverter.py`.

### 2. Projekt einrichten

#### a) Ordnerstruktur anlegen

Erstellen Sie die Basis-Ordnerstruktur:

```bash
mkdir -p 01_gsms/ihre-bibliothek
mkdir -p 02_hsf
mkdir -p 03_backups/timestamped
mkdir -p 04_logs
```

#### b) GSM-Dateien platzieren

Kopieren Sie Ihre GSM-Dateien nach:
```
01_gsms/ihre-bibliothek/objekt1.gsm
01_gsms/ihre-bibliothek/objekt2.gsm
```

**Wichtig:** Der Ordnername unter `01_gsms/` wird automatisch als Bibliotheksname erkannt!

---

## 🪟 Windows-spezifische Hinweise

GDLnucleus Light funktioniert auf Windows genauso wie auf macOS. Beachten Sie nur folgende Unterschiede:

### Python 3 Installation (Windows)

1. **Download:** [python.org/downloads](https://www.python.org/downloads/)
2. **Installation:** 
   - ⚠️ **Wichtig:** Aktivieren Sie "Add Python to PATH" während der Installation!
   - Standardeinstellungen sonst beibehalten
3. **Prüfen:** Öffnen Sie PowerShell und testen Sie:
   ```powershell
   python --version
   ```
   Sollte zeigen: `Python 3.x.x`

### LP_XMLConverter Pfad (Windows)

Typische Pfade unter Windows:

```
C:\Program Files\Graphisoft\ArchiCAD 27\LP_XMLConverter.exe
C:\Program Files\Graphisoft\ArchiCAD 26\LP_XMLConverter.exe
C:\Program Files\Graphisoft\ArchiCAD 28\LP_XMLConverter.exe
```

Die Konfiguration in `gdlconfig.json` ist bereits für Windows vorbereitet:

```json
"platforms": {
  "windows": {
    "lpxmlconverter": "C:\\Program Files\\Graphisoft\\ArchiCAD 27\\LP_XMLConverter.exe"
  }
}
```

### Unterschiede im Arbeitsablauf

| Aspekt | macOS | Windows |
|--------|-------|---------|
| Python Befehl | `python3` | `python` |
| Pfadtrennzeichen | `/` | `\` (wird automatisch behandelt) |
| Tastenkürzel | `Cmd+Shift+B` | `Ctrl+Shift+B` |
| Terminal | Terminal.app / iTerm | PowerShell / cmd |

**Gute Nachricht:** Die Tasks in VS Code/Cursor funktionieren auf beiden Plattformen identisch! 
- Der richtige Python-Befehl (`python3` auf macOS/Linux, `python` auf Windows) wird automatisch verwendet
- Pfade werden automatisch korrekt behandelt
- Der GDL Task Runner funktioniert plattformübergreifend

---

## ⚙️ Konfiguration

### LP_XMLConverter Pfad anpassen

Öffnen Sie `gdlconfig.json` und passen Sie den Pfad zum LP_XMLConverter an:

```json
{
  "lpxmlconverter": "/Applications/Graphisoft/AC27/ArchiCAD 27.app/Contents/MacOS/LP_XMLConverter.app/Contents/MacOS/LP_XMLConverter",
  "printtimes": false,
  "passwords": {},
  "gsmbackupdirectories": [
    {
      "directory": "{$projectpath}/03_backups/timestamped",
      "filename": "{$filename}_{$strftime}.gsm",
      "strftime": "%Y_%m_%d_%H_%M"
    }
  ],
  "platforms": {
    "windows": {
      "lpxmlconverter": "C:\\Program Files\\Graphisoft\\ArchiCAD 27\\LP_XMLConverter.exe"
    },
    "darwin": {
      "lpxmlconverter": "/Applications/Graphisoft/AC27/ArchiCAD 27.app/Contents/MacOS/LP_XMLConverter.app/Contents/MacOS/LP_XMLConverter"
    }
  }
}
```

#### Pfad finden:

**macOS:**
```bash
# Standard-Pfad ArchiCAD 27
/Applications/Graphisoft/AC27/ArchiCAD 27.app/Contents/MacOS/LP_XMLConverter.app/Contents/MacOS/LP_XMLConverter

# Standard-Pfad ArchiCAD 26
/Applications/Graphisoft/AC26/ArchiCAD 26.app/Contents/MacOS/LP_XMLConverter.app/Contents/MacOS/LP_XMLConverter
```

**Windows:**
```
C:\Program Files\Graphisoft\ArchiCAD 27\LP_XMLConverter.exe
```

### Workspace-Datei anpassen

Benennen Sie `gdl-nucleus-light.code-workspace` um, damit sie zu Ihrem Projekt passt:

```bash
mv gdl-nucleus-light.code-workspace ihr-projekt.code-workspace
```

Öffnen Sie die Datei und ändern Sie den Namen:

```json
{
  "folders": [
    {
      "name": "ihr-projekt.project",
      "path": "."
    }
  ],
  "settings": {}
}
```

### GDL Task Runner Extension installieren (empfohlen)

Die **GDL Task Runner Extension** macht die Verwendung der Tasks noch einfacher:

1. **Extension installieren:**
   - Die Extension-Datei liegt in `.vscode/task-runner-extension/gdl-task-runner-1.0.0.vsix`
   - In VS Code/Cursor: `Extensions` → `...` (Drei Punkte) → `Install from VSIX...`
   - Wählen Sie die `.vsix` Datei

2. **Verwendung:**
   - Nach der Installation erscheint ein neuer Tab "GDL Task Runner" in der Seitenleiste
   - Alle verfügbaren Tasks werden dort aufgelistet
   - Ein Klick auf ▶️ führt den Task aus

**Vorteile:**
- ✅ Übersichtliche Task-Liste
- ✅ Ein-Klick-Ausführung
- ✅ Kein Tastenkürzel merken nötig

---

## 🔄 Arbeitsablauf

### GSM → HSF konvertieren

1. **In VS Code / Cursor öffnen:**
   - Öffnen Sie die `.code-workspace` Datei

2. **Task ausführen:**
   - **Mit GDL Task Runner:** Klicken Sie auf ▶️ neben `GSM2HSF (all files)`
   - **Alternativ:** `Cmd+Shift+P` → `Tasks: Run Task` → `GSM2HSF (all files)`

3. **Ergebnis:**
   - HSF-Dateien werden in `02_hsf/objektname/objektname/` erstellt
   - GDL-Scripts liegen unter `02_hsf/objektname/objektname/scripts/`

### HSF → GSM konvertieren

1. **Scripts bearbeiten:**
   - Öffnen Sie die `.gdl` Dateien in `02_hsf/objektname/objektname/scripts/`
   - Bearbeiten Sie den Code

2. **Task ausführen:**
   - **Mit GDL Task Runner:** Klicken Sie auf ▶️ neben `HSF2GSM (all files)`
   - **Alternativ:** `Cmd+Shift+P` → `Tasks: Run Task` → `HSF2GSM (all files)`

3. **Ergebnis:**
   - GSM-Datei in `01_gsms/bibliothek/objektname.gsm` wird überschrieben
   - Automatisches Backup in `03_backups/timestamped/` erstellt

⸻
   
   Bilder in GDL-Objekte einbetten
   
   GDLnucleus Light kümmert sich automatisch um die Bildregistrierung während der HSF → GSM-Konvertierung.
   
   1. Leg deine Bilddatei(en) in 02_hsf/Objektname/Objektname/images/ ab
   (beliebiger Name, z. B. my-button.png – außer Picture_0.png, das für das Objektsymbol reserviert ist)
   2.    Starte HSF2GSM – der Konverter benennt die Datei(en) automatisch in GDLPict_1.png,
   GDLPict_2.png, … um und registriert sie in libpartdata.xml
   3.    Verweise in deinem GDL-Skript mit UI_PICT 1 (oder PICTURE 1 usw.) auf das Bild
   4.    Das Bild wird in die resultierende GSM-Datei eingebettet
   
   Hinweis: Picture_0.png ist immer das Objektsymbol und wird nie umbenannt oder neu registriert.

---

## 📋 Verfügbare Tasks

| Task | Beschreibung |
|------|--------------|
| **GSM2HSF (all files)** | Konvertiert alle GSM → HSF |
| **HSF2GSM (all files)** | Konvertiert alle HSF → GSM |

**Hinweis:** Die Tasks führen jetzt das ausführbare Skript `bin/gdlconverter.py` direkt aus (Shebang `#!/usr/bin/env python3`) und verwenden `PYTHONUNBUFFERED=1` für unbuffered-Ausgabe — äquivalent zu `python3 -u`.

### Tasks ausführen mit GDL Task Runner

Dieses Projekt nutzt die **GDL Task Runner Extension** für VS Code/Cursor:

1. **Task Runner öffnen:**
   - In der Seitenleiste erscheint das GDL Task Runner Icon
   - Oder: Klicken Sie auf den Task Runner Tab

2. **Task ausführen:**
   - Wählen Sie den gewünschten Task aus der Liste
   - Klicken Sie auf ▶️ (Play-Button) neben dem Task

3. **Output beobachten:**
   - Das Terminal zeigt den Fortschritt
   - Erfolgreiche Konvertierungen werden bestätigt

**Alternative (ohne Extension):**
- Tastenkürzel: `Cmd+Shift+B` (macOS) / `Ctrl+Shift+B` (Windows)
- Oder: `Cmd+Shift+P` → `Tasks: Run Task`

---

## 🔧 Anpassungen für Ihr Projekt

### 1. Projektnamen ändern

**Ordnername:**
```bash
mv gdl-nucleus-light.project ihr-projekt.project
```

**Workspace-Datei:**
```bash
cd ihr-projekt.project
mv gdl-nucleus-light.code-workspace ihr-projekt.code-workspace
```

In der Workspace-Datei:
```json
{
  "folders": [
    {
      "name": "ihr-projekt.project",  ← hier ändern
      "path": "."
    }
  ]
}
```

### 2. Bibliotheksnamen ändern

Der Bibliotheksname wird automatisch aus dem ersten Ordner unter `01_gsms/` erkannt:

```
01_gsms/
└── meine-bibliothek/    ← Dieser Name wird verwendet
    └── objekt.gsm
```

**Wichtig:** Der Ordnername sollte keine Leerzeichen enthalten!

### 3. ArchiCAD Version anpassen

In `gdlconfig.json`:

```json
{
  "lpxmlconverter": "/Applications/Graphisoft/AC28/ArchiCAD 28.app/...",
  "platforms": {
    "darwin": {
      "lpxmlconverter": "/Applications/Graphisoft/AC28/ArchiCAD 28.app/..."
    }
  }
}
```

---

## 🔍 Fehlerbehebung

### "python3: command not found" (Windows)

**Problem:** Python ist nicht installiert oder nicht im PATH.

**Lösung:**
1. Installieren Sie Python 3 von [python.org](https://www.python.org/downloads/)
2. **Wichtig:** Aktivieren Sie bei der Installation "Add Python to PATH"
3. Starten Sie VS Code/Cursor neu
4. Testen Sie in PowerShell: `python --version`

### "lpxmlconverter path not found"

**Problem:** Der Pfad zum LP_XMLConverter ist falsch.

**Lösung:**
1. Prüfen Sie, ob ArchiCAD installiert ist
2. Passen Sie den Pfad in `gdlconfig.json` an
3. Prüfen Sie beide Stellen: `lpxmlconverter` (Haupteintrag) und `platforms.darwin.lpxmlconverter`

### "HSF folder not found"

**Problem:** Es existiert kein HSF-Ordner für das Objekt.

**Lösung:**
1. Führen Sie zuerst `GSM2HSF` aus
2. Prüfen Sie, ob Dateien in `02_hsf/` vorhanden sind

### "No library folder found"

**Problem:** Kein Ordner unter `01_gsms/` gefunden.

**Lösung:**
1. Erstellen Sie den Bibliotheksordner: `mkdir -p 01_gsms/ihre-bibliothek`
2. Legen Sie GSM-Dateien dort ab

### Script findet keine GSM-Dateien

**Problem:** GSM-Dateien liegen im falschen Ordner.

**Erwartete Struktur:**
```
01_gsms/
└── bibliotheksname/     ← Bibliotheksordner (wird automatisch erkannt)
    ├── objekt1.gsm      ← GSM-Dateien hier!
    └── objekt2.gsm
```

---

## 📝 Backup-Strategie

Bei jeder **HSF → GSM** Konvertierung wird automatisch ein Backup erstellt:

```
03_backups/
└── timestamped/
    ├── objekt_2025_12_23_14_30.gsm
    ├── objekt_2025_12_23_15_45.gsm
    └── objekt_2025_12_23_16_10.gsm
```

**Format:** `objektname_YYYY_MM_DD_HH_MM.gsm`

**Tipp:** Alte Backups können Sie manuell löschen, wenn sie nicht mehr benötigt werden.

---

## 🆚 GDLnucleus Light vs. Vollversion

| Feature | Light | Vollversion |
|---------|-------|-------------|
| GSM ↔ HSF | ✅ | ✅ |
| GSM ↔ XML | ❌ | ✅ |
| LCF-Container | ❌ | ✅ |
| Parameter-CSV Export | ❌ | ✅ |
| Bild-Verwaltung | ✅ | ✅ |
| SVG → TIFF | ❌ | ✅ |

---

## 💡 Tipps & Best Practices

1. **Versionskontrolle:**
   - Fügen Sie das `02_hsf/` Verzeichnis zu Git hinzu
   - Ignorieren Sie `03_backups/` und `04_logs/` in `.gitignore`

2. **Workflow:**
   - GSM → HSF einmal zu Projektbeginn
   - Dann nur noch HSF-Dateien bearbeiten
   - HSF → GSM nach jeder Änderung

3. **Sicherheit:**
   - Backups werden automatisch erstellt
   - Originale GSM-Dateien werden nur bei erfolgreicher Konvertierung überschrieben

4. **Team-Arbeit:**
   - HSF-Dateien sind textbasiert → perfekt für Git
   - Merge-Konflikte in GDL-Scripts sind lesbar und lösbar

---

## 📞 Support & Kontakt

Bei Fragen oder Problemen:
- Prüfen Sie die Log-Dateien in `04_logs/`
- Kontaktieren Sie den Entwickler

**Version:** GDLnucleus Light 1.1
**Letzte Aktualisierung:** Februar 2026

---

## 📄 Lizenz

Kostenlose Light-Version für den persönlichen und kommerziellen Gebrauch.

