// js/main.js

// Globale Variablen werden hier nur deklariert.
// Die Zuweisung der DOM-Elemente erfolgt innerhalb von DOMContentLoaded.
window.gdlInput;
window.outWInput;
window.outHInput;
window.qualitySelect;
window.filenameInput;
window.convertBtn; // War im Original-JS nicht direkt an click gebunden, aber zum Abrufen ok
window.zoomSlider;
window.zoomValue;
window.previewBox;
window.svgCodePreview;
window.downloadSVGBtn;
window.downloadPNGBtn;
window.parametersInput;
window.saveGdlBtn;
window.loadGdlBtn;

// Globale Zustandsvariablen können direkt zugewiesen werden.
window.currentSVG = "";
window.currentErrors = [];
window.debounceTimer = null;

// Dieser Code wird ausgeführt, sobald das DOM vollständig geladen ist.
document.addEventListener('DOMContentLoaded', () => {
	// Hole alle DOM-Elemente und weise sie den globalen Variablen zu.
	// DIESER TEIL IST ENTSCHEIDEND! Hier wird sichergestellt, dass die Elemente existieren.
	window.gdlInput = document.getElementById('gdl-input');
	window.outWInput = document.getElementById('output-width');
	window.outHInput = document.getElementById('output-height');
	window.qualitySelect = document.getElementById('quality-select');
	window.filenameInput = document.getElementById('filename-input');
	window.convertBtn = document.getElementById('convert-btn'); // Auch diesen jetzt hier abrufen
	window.zoomSlider = document.getElementById('zoom-slider');
	window.zoomValue = document.getElementById('zoom-value');
	window.previewBox = document.getElementById('preview-box');
	window.svgCodePreview = document.querySelector('#svg-code-preview code');
	window.downloadSVGBtn = document.getElementById('download-svg-btn');
	window.downloadPNGBtn = document.getElementById('download-png-btn');
	window.parametersInput = document.getElementById('parameters-input');
	window.saveGdlBtn = document.getElementById('save-gdl-btn');
	window.loadGdlBtn = document.getElementById('load-gdl-btn');

	// 1. Lokale Speicherung laden
	// `loadFromLocalStorage` greift auf `window.gdlInput` und `window.parametersInput` zu,
	// die jetzt garantiert zugewiesen sind.
	loadFromLocalStorage();

	// 2. Event-Listener für UI-Elemente
	// Die Funktionen `saveGdlProject`, `loadGdlProject`, `debouncedConvert`, `handleZoom`,
	// `handleDownloadSVG`, `handleDownloadPNG`, `setupLocalStorageListeners`, `handleConvert`
	// sind global verfügbar, da sie in den vorherigen Skripten als Funktionen deklariert wurden.

	// Speichern/Laden-Buttons
	window.saveGdlBtn.addEventListener('click', saveGdlProject);
	window.loadGdlBtn.addEventListener('click', loadGdlProject);

	// Debouncing Logik für Input-Felder und Select
	window.gdlInput.addEventListener('input', debouncedConvert);
	window.outWInput.addEventListener('input', debouncedConvert);
	window.outHInput.addEventListener('input', debouncedConvert);
	window.qualitySelect.addEventListener('change', debouncedConvert); 
	window.parametersInput.addEventListener('input', debouncedConvert);
	// Optional: Falls Sie den "Convert"-Button weiterhin als expliziten Trigger wünschen,
	// der sofort (nicht debounced) konvertiert:
	// window.convertBtn.addEventListener('click', handleConvert);

	// Weitere UI-Listener
	window.zoomSlider.addEventListener('input', handleZoom);
	window.downloadSVGBtn.addEventListener('click', handleDownloadSVG);
	window.downloadPNGBtn.addEventListener('click', handleDownloadPNG);

	// Initialisierung der localStorage-Listener nach dem Laden der Werte
	setupLocalStorageListeners();

	// 3. Initial Run on Page Load
	handleConvert();
});
